//
//  GSContentProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.05.20.
//  Copyright © 2020 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSContentProtocol <NSObject>

/** Returns the content of the object to store it in pList.

 This is used to store the data in the .glyphs file.
 @param format the version of the dict
 */
- (NSDictionary *)propertyListValueFormat:(GSFormatVersion)format;

- (NSDictionary *)clipboardValueFormat:(GSFormatVersion)format;

@end

NS_ASSUME_NONNULL_END
